\name{summary.emaxsimobj}
\alias{summary.emaxsimobj}

\title{Summarize Emax fit to a data set generated by emaxsim }
\description{
 Summary of the Emax or alternative fit to a simulated data
set}

\usage{
\method{summary}{emaxsimobj}(object, ...)
}

\arguments{
  \item{object}{Extracted simulation object }
  \item{\dots}{No other parameters are currently implemented }
}

\value{
Printed output only.  No values are returned.
}

\author{Neal Thomas }

\seealso{ \code{\link{emaxsim}}, 
\code{\link{plot.emaxsimobj}}, \code{\link{print.emaxsimobj}} }
\examples{

## emaxsim changes the random number seed
nsim<-3
doselev<-c(0,5,25,50,100)
n<-c(78,81,81,81,77)

### population parameters for simulation
e0<-2.465375 
ed50<-67.481113 
emax<-15.127726
sdy<-7.967897
pop<-c(log(ed50),emax,e0)    
meanlev<-emaxfun(doselev,pop)  

###FixedMean is specialized constructor function for emaxsim
gen.parm<-FixedMean(n,doselev,meanlev,sdy)  
D1 <- emaxsim(nsim,gen.parm,nproc=1)
e3<-D1[3]

summary(e3)  
}
\keyword{nonlinear}

