% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aemet_monthly.R
\name{aemet_monthly}
\alias{aemet_monthly}
\alias{aemet_monthly_clim}
\alias{aemet_monthly_period}
\alias{aemet_monthly_period_all}
\title{Monthly/annual climatology}
\usage{
aemet_monthly_clim(
  station = NULL,
  year = 2020,
  verbose = FALSE,
  return_sf = FALSE
)

aemet_monthly_period(
  station = NULL,
  start = 2018,
  end = 2020,
  verbose = FALSE,
  return_sf = FALSE
)

aemet_monthly_period_all(
  start = 2019,
  end = 2020,
  verbose = FALSE,
  return_sf = FALSE
)
}
\arguments{
\item{station}{Character string with station identifier code(s)
(see \code{\link[=aemet_stations]{aemet_stations()}})}

\item{year}{Numeric value as date (format: YYYY).}

\item{verbose}{Logical \code{TRUE/FALSE}. Provides information about the flow of
information between the client and server.}

\item{return_sf}{Logical \code{TRUE} or \code{FALSE}.
Should the function return an \code{sf} spatial object? If \code{FALSE}
(the default value) it returns a tibble. Note that you need to
have the \code{sf} package installed.}

\item{start}{Numeric value as start year (format: YYYY).}

\item{end}{Numeric value as end year (format: YYYY).}
}
\value{
A tibble or a \code{sf} object
}
\description{
Get monthly/annual climatology values for a station or all the stations.
\code{aemet_monthly_period()} and \code{aemet_monthly_period_all()} allows requests
that span several years.
}
\section{API Key}{
You need to set your API Key globally using \code{\link[=aemet_api_key]{aemet_api_key()}}.
}

\examples{

# Run this example only if AEMET_API_KEY is set

if (aemet_detect_api_key()) {
  library(tibble)
  obs <- aemet_monthly_clim(station = c("9434", "3195"), year = 2000)
  glimpse(obs)
}
}
\seealso{
Other aemet_api_data: 
\code{\link{aemet_daily_clim}()},
\code{\link{aemet_extremes_clim}()},
\code{\link{aemet_last_obs}()},
\code{\link{aemet_normal}},
\code{\link{aemet_stations}()}
}
\concept{aemet_api_data}
