% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{set_cleanr_options}
\alias{set_cleanr_options}
\title{Set Options for \pkg{cleanr}}
\usage{
set_cleanr_options(..., reset = FALSE, overwrite = TRUE)
}
\arguments{
\item{...}{See \code{\link{options}}. See \code{\link{function_checks}} and
\code{\link{file_checks}} for options to be set with \pkg{cleanr}.
Use \code{\link{get_cleanr_options}} to get the current values.
\pkg{cleanr}'s standard defaults are:
\Sexpr[results=verbatim]{cat(paste(names(cleanr::gco()), 
                                   cleanr::gco(flatten_list = FALSE),
                                   sep = "=", collapse = "\n"), "\n")}}

\item{reset}{[boolean(1)]\cr Reset all \pkg{cleanr} options to the package's
defaults?}

\item{overwrite}{[boolean(1)]\cr Overwrite options already set? Is set to
\code{FALSE} on package loading to ensure your previously set \pkg{cleanr}
options won't get overridden. Just ignore that argument.}
}
\value{
invisible(TRUE)
}
\description{
A convenience function for \code{\link{options}}.
}
\details{
\pkg{cleanr} loads a couple of options as defaults for its 
functions.
The defaults are stored in a list element of \code{\link{options}}.
All checks (see \code{\link{function_checks}} and \code{\link{file_checks}})
can be disabled by setting the corresponding option list item to \code{NULL}
or \code{FALSE}.
}
\examples{
# R.C. Martin's Clean Code recommends monadic argument lists.
set_cleanr_options(max_num_arguments = 1)
# R.C. Martin's Clean Code recommends functions less than 20 lines long.
set_cleanr_options(max_lines = 30, max_lines_of_code = 20)
# same as above:
set_cleanr_options(list(max_lines = 30, max_lines_of_code = 20))
get_cleanr_options(flatten_list = TRUE)
# we delete all options and set some anew
options("cleanr" = NULL)
options("cleanr" = list(max_lines = 30, max_lines_of_code = 20))
# fill the missing options with the package's defaults:
set_cleanr_options(overwrite = FALSE)
get_cleanr_options(flatten_list = TRUE)
# reset to the package's defaults:
set_cleanr_options(reset = TRUE)
get_cleanr_options(flatten_list = TRUE)
}
\author{
Andreas Dominik Cullmann, <adc-r@arcor.de>
}

