% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cja_get_dateranges.R
\name{cja_get_dateranges}
\alias{cja_get_dateranges}
\title{Get a paginated list of dateranges in CJA}
\usage{
cja_get_dateranges(
  locale = "en_US",
  filterByIds = NULL,
  limit = 10,
  page = 0,
  expansion = "definition",
  includeType = "all",
  debug = FALSE
)
}
\arguments{
\item{locale}{Locale - Default: "en_US"}

\item{filterByIds}{Filter list to only include date ranges in the specified list (comma-delimited list of IDs). This has filtered Ids from tags, approved, favorites and user specified Ids list.}

\item{limit}{Number of results per page. default is 10}

\item{page}{Page number (base 0 - first page is "0")}

\item{expansion}{Comma-delimited list of additional date range metadata fields to include on response.}

\item{includeType}{Include additional filters not owned by user. Default is "all". Options include: "all" (default), "shared", "templates"}

\item{debug}{Used to help troubleshoot api call issues. Shows the call and result in the console}
}
\value{
A data frame of dateranges and their corresponding metadata
}
\description{
This function allows users to pull a list of stored date ranges so that they can be reused in an analysis.
}
\details{
\emph{expansion} options can include any of the following:
"definition" "modified" "ownerFullName" "sharesFullName" "shares" "tags"

\emph{includeType} options can include any of the following:
"all", "shared", "templates"
}
\examples{
\dontrun{
cja_get_dateranges()
}
}
