% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dnn.R
\name{coef.citodnn}
\alias{coef.citodnn}
\title{Returns list of parameters the neural network model currently has in use}
\usage{
\method{coef}{citodnn}(object, ...)
}
\arguments{
\item{object}{a model created by \code{\link{dnn}}}

\item{...}{nothing implemented yet}
}
\value{
list of weights of neural network
}
\description{
Returns list of parameters the neural network model currently has in use
}
\examples{
\donttest{
if(torch::torch_is_installed()){
library(cito)

set.seed(222)
validation_set<- sample(c(1:nrow(datasets::iris)),25)

# Build and train  Network
nn.fit<- dnn(Sepal.Length~., data = datasets::iris[-validation_set,])

# Sturcture of Neural Network
print(nn.fit)

#analyze weights of Neural Network
coef(nn.fit)
}
}
}
