% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichment_functions.R
\name{GSEA}
\alias{GSEA}
\title{GSEA}
\usage{
GSEA(genes, geneset)
}
\arguments{
\item{genes}{DA gene names to be checked if they are over-represented or not.}

\item{geneset}{Pathways to be used in enrichment analyses. If not set vp2008 (Chaussabel, 2008)
immune modules will be used. This can be set to any geneset using `read.gmt` function from `qusage`
package. Different modules are available: https://www.gsea-msigdb.org/gsea/downloads.jsp.}
}
\value{
data.frame, list of pathways and their enrichment (adjusted) p-values.
}
\description{
Gene set enrichment analyses, runs 'fgsea' package implementation with preset values.
}
\examples{
\donttest{
library(cinaR)
library(fgsea)
data(examplePathways)
data(exampleRanks)
GSEA(exampleRanks, examplePathways)
}
}
\references{
G. Korotkevich, V. Sukhov, A. Sergushichev. Fast gene set enrichment analysis. bioRxiv (2019),
doi:10.1101/060012
}
