% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resample_cifti.R
\name{resample_cifti}
\alias{resample_cifti}
\alias{resampleCIfTI}
\alias{resamplecii}
\alias{resample_xifti}
\title{Resample CIFTI Data}
\usage{
resample_cifti(
  x = NULL,
  cifti_target_fname = NULL,
  surfL_original_fname = NULL,
  surfR_original_fname = NULL,
  surfL_target_fname = NULL,
  surfR_target_fname = NULL,
  resamp_res,
  write_dir = NULL,
  mwall_values = c(NA, NaN),
  verbose = TRUE
)

resampleCIfTI(
  x = NULL,
  cifti_target_fname = NULL,
  surfL_original_fname = NULL,
  surfR_original_fname = NULL,
  surfL_target_fname = NULL,
  surfR_target_fname = NULL,
  resamp_res,
  write_dir = NULL,
  mwall_values = c(NA, NaN),
  verbose = TRUE
)

resamplecii(
  x = NULL,
  cifti_target_fname = NULL,
  surfL_original_fname = NULL,
  surfR_original_fname = NULL,
  surfL_target_fname = NULL,
  surfR_target_fname = NULL,
  resamp_res,
  write_dir = NULL,
  mwall_values = c(NA, NaN),
  verbose = TRUE
)

resample_xifti(
  x = NULL,
  cifti_target_fname = NULL,
  surfL_original_fname = NULL,
  surfR_original_fname = NULL,
  surfL_target_fname = NULL,
  surfR_target_fname = NULL,
  resamp_res,
  write_dir = NULL,
  mwall_values = c(NA, NaN),
  verbose = TRUE
)
}
\arguments{
\item{x}{The CIFTI file name or \code{"xifti"} object to resample. If
\code{NULL}, the result will be a \code{"xifti"} with resampled surfaces
given by \code{surfL_original_fname} and \code{surfR_original_fname}.}

\item{cifti_target_fname}{File name for the resampled CIFTI. Will be placed
in \code{write_dir}. If \code{NULL}, will be written to "resampled.d*.nii".
\code{write_dir} will be appended to the beginning of the path.}

\item{surfL_original_fname, surfR_original_fname}{(Optional) Path to a GIFTI
surface geometry file representing the left/right cortex. One or both can be
provided. These will be resampled too, and are convenient for visualizing
the resampled data.

If \code{x} is a \code{"xifti"} object with surfaces, these arguments
will override the surfaces in the \code{"xifti"}.}

\item{surfL_target_fname, surfR_target_fname}{(Optional) File names for the
resampled GIFTI surface geometry files. Will be placed in \code{write_dir}.
If \code{NULL} (default), will use default names created by
\code{\link{resample_cifti_default_fname}}.}

\item{resamp_res}{Target resolution for resampling (number of
cortical surface vertices per hemisphere).}

\item{write_dir}{Where to write the resampled CIFTI (and surfaces if present.)
If \code{NULL} (default), will use the current working directory if \code{x}
was a CIFTI file, and a temporary directory if \code{x} was a \code{"xifti"}
object.}

\item{mwall_values}{If the medial wall locations are not indicated in the
CIFTI, use these values to infer the medial wall mask. Default:
\code{c(NA, NaN)}. If \code{NULL}, do not attempt to infer the medial wall.

Correctly indicating the medial wall locations is important for resampling,
because the medial wall mask is taken into account during resampling
calculations.}

\item{verbose}{Should occasional updates be printed? Default: \code{TRUE}.}
}
\value{
A named character vector of written files: \code{"cifti"} and
potentially \code{"surfL"} (if \code{surfL_original_fname} was provided)
and/or \code{"surfR"} (if \code{surfR_original_fname} was provided).
}
\description{
Performs spatial resampling of CIFTI data on the cortical surface
by separating it into GIFTI and NIFTI files, resampling the GIFTIs, and then
putting them together. (The subcortex is not resampled.)
}
\details{
Can accept a \code{"xifti"} object as well as a path to a CIFTI-file.
}
\section{Connectome Workbench Requirement}{

This function uses a system wrapper for the 'wb_command' executable. The
user must first download and install the Connectome Workbench, available
from https://www.humanconnectome.org/software/get-connectome-workbench .
}

