% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_pi_lm.R
\name{add_pi.lm}
\alias{add_pi.lm}
\title{Prediction Intervals for Linear Model Predictions}
\usage{
\method{add_pi}{lm}(tb, fit, alpha = 0.05, names = NULL,
  yhatName = "pred", log_response = FALSE, ...)
}
\arguments{
\item{tb}{A tibble or data frame of new data.}

\item{fit}{An object of class lm. Predictions are made with this
object.}

\item{alpha}{A real number between 0 and 1. Controls the confidence
level of the interval estimates.}

\item{names}{\code{NULL} or character vector of length two. If
\code{NULL}, prediction bounds automatically will be named by
\code{add_pi}, otherwise, the lower prediction bound will be
named \code{names[1]} and the upper prediction bound will be
named \code{names[2]}.}

\item{yhatName}{A string. Name of the predictions vector.}

\item{log_response}{A logical. If TRUE, prediction intervals will be
generated at the \emph{response level} of a log-linear model:
\eqn{\log(Y) = X\beta + \epsilon}. Again, these intervals will
be on the scale of the original response, Y.}

\item{...}{Additional arguments.}
}
\value{
A tibble, \code{tb}, with predicted values, upper and lower
    prediction bounds attached.
}
\description{
This function is one of the methods for \code{add_pi} and is
automatically called when an object of class \code{lm} is passed to
to \code{add_pi}.
}
\details{
Prediction intervals for \code{lm} objects are calculated
parametrically. This function is essentially just a wrapper for
\code{predict(fit, tb, interval = "prediction")} if \code{fit} is a
linear model. If \code{log_response = TRUE}, prediction intervals
for the response are calculated parametrically, then the
exponential function is applied to transform them to the original
scale.
}
\examples{
# Fit a linear model
fit <- lm(dist ~ speed, data = cars)
# Add prediction intervals and fitted values to the original data
add_pi(cars, fit)

# Try to add predictions to a data frame of new data
new_data <- cars[sample(NROW(cars), 10), ]
add_pi(new_data, fit)

# Try a different confidence level
add_pi(cars, fit, alpha = 0.5)

# Add custom names to the prediction bounds.
add_pi(cars, fit, alpha = 0.5, names = c("lwr", "upr"))
}
\seealso{
\code{\link{add_ci.lm}} for confidence intervals for
    \code{lm} objects. \code{\link{add_probs.lm}} for conditional
    probabilities of \code{lm} objects, and
    \code{\link{add_quantile.lm}} for response quantiles of
    \code{lm} objects.
}
