% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/XArray-subset.R
\name{[,XArray,ANY,ANY-method}
\alias{[,XArray,ANY,ANY-method}
\title{Indexing to extract subsets of a code{\link{RasterArray}} or \code{\link{SpatialArray}} object}
\usage{
\S4method{[}{XArray,ANY,ANY}(x, i, j, ..., drop = TRUE)
}
\arguments{
\item{x}{\code{\link{RasterArray}} or \code{\link{SpatialArray}}  object.}

\item{i}{subscript of the first dimension(rows) or vector-like subsetting.}

\item{j}{subscript of the second dimension (columns).}

\item{...}{subscript of additional dimensions.}

\item{drop}{\code{logical} in case the result of subsetting is a single element, should the \code{\link{RasterArray}} or \code{\link{SpatialArray}}  wrapper be dropped and the element be reduced to a single \code{RasterLayer} or \code{Spatial*}?}
}
\value{
A \code{RasterLayer}, \code{RasterArray}, \code{Spatial*} or \code{\link{SpatialArray}} class object.
}
\description{
Single bracket \code{'['} refers to indices and names within the \code{\link{RasterArray}} . Use double brackets to extract layers based on their names (in the stack).
}
\examples{
data(dems)
# numeric subsetting
firstThree <- dems[1:3]
# character subsetting
second <- dems["10"]
# logical subsetting
subscript <- rep(FALSE, length(dems))
subscript[2] <- TRUE
second2 <- dems[subscript]
data(coasts)
present<- coasts["0", ]
allMargin <- coasts[, "margin"]

}
