% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RasterArray-combine.R
\name{cbind.RasterArray}
\alias{cbind.RasterArray}
\alias{rbind.RasterArray}
\title{Combine RasterLayers or RasterArrays by rows or columns}
\usage{
\method{cbind}{RasterArray}(...)

\method{rbind}{RasterArray}(...)
}
\arguments{
\item{...}{RasterLayer or RasterArray class objects to be combined.}
}
\value{
A \code{RasterArray} class object.
}
\description{
The function takes a sequence of \code{RasterLayer} or \code{RasterArray} class objects and combines them to two dimensional \code{RasterArrays}...
Named objects will be forced together based on \code{names}, \code{colnames} or \code{rownames} attributes, via insertion of \code{NAs}.
}
\examples{
data(dems)
# create matrices out of vectors
colb <- cbind(dems, dems)
rowb <- rbind(dems, dems)
# automatic name matching
dems2 <- dems[c(1:4, 6:10)]
matched <- suppressWarnings(cbind(dems, dems2))
}
