% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{newbounds}
\alias{newbounds}
\title{Redefine bounds of a named matrix}
\usage{
newbounds(x, cols = NULL, rows = NULL)
}
\arguments{
\item{x}{The matrix to be restructured.}

\item{cols}{Column names guiding the restructuring.}

\item{rows}{Row names guiding the restructuring.}
}
\value{
A matrix with extended bounds.
}
\description{
The function restructures a \code{\link[base]{matrix}} and extends its current limits to a range defined by a names attribute
}
\details{
This is essentially a subsetting function that allows you to subset even when the rownames or colnames vector
extends beyond the bounds of a matrix and traditional subsetting methods result in the notorious 'out of bounds' error.
}
\examples{
a<-matrix(1:9, ncol=3)
rownames(a) <- c("a", "c", "d")
newbounds(a, rows=letters[1:5])
}
