% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text.R
\name{add_code}
\alias{add_code}
\title{#' Add formatted code chunks to a chronicle Rmarkdown report}
\usage{
add_code(report, code, code_title = NULL, title_level = 2, eval = FALSE)
}
\arguments{
\item{report}{character containing the text of an Rmarkdown report header (and possibly more chunks). Easily create one with chronicle::new_report()}

\item{code}{Character string to be formated as an R code chunk. This code will not be excecuted when the report is rendered.}

\item{code_title}{The title of the code section. Default is NULL.}

\item{title_level}{Level of the section title (ie, number of # on Rmarkdown syntax.)}

\item{eval}{Excecute the code sent to the chunk. Default is FALSE.}
}
\value{
The text of the Rmarkdown report plus an additional section with the code chunk.
}
\description{
Beware that code indentation of the chronicle call will affect the indentation of the chunk, so make sure not to leave unintended indentation in the 'code' parameter on this function call.
}
\examples{
html_report <- add_code(report = new_report(),
                        code_title = 'Code comes after this title',
                        code = 'f <- function(x, y){paste(x,y)}
f("a", "b")')
}
