% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/montecarlo_gcms.R
\name{montecarlo_gcms}
\alias{montecarlo_gcms}
\title{Perform Monte Carlo Permutations on GCMs}
\usage{
montecarlo_gcms(
  s,
  var_names = c("bio_1", "bio_12"),
  study_area = NULL,
  scale = TRUE,
  perm = 10000,
  dist_method = "euclidean",
  clustering_method = "closestdist",
  ...
)
}
\arguments{
\item{s}{A list of stacks of General Circulation Models (GCMs).}

\item{var_names}{Character. A vector of names of the variables to include, or 'all' to include all variables.}

\item{study_area}{An Extent object, or any object from which an Extent object can be extracted.
Defines the study area for cropping and masking the rasters.}

\item{scale}{Logical. Should the data be centered and scaled? Default is \code{TRUE}.}

\item{perm}{Integer. The number of permutations to perform.}

\item{dist_method}{Character. The method for distance matrix computation. Default is "euclidean." Possible values are:
"euclidean," "maximum," "manhattan," "canberra," "binary," or "minkowski." If \code{NULL}, clustering will be performed on the raw variable data.}

\item{clustering_method}{Character. The method for clustering. Default is "closestdist." Possible values are: "kmeans," "hclust," or "closestdist."}

\item{...}{Additional arguments to pass to the clustering function.}
}
\value{
A violin plot showing the results. The dashed red line and red dots represent the mean absolute distance between subsets of GCMs using the clustering approach. The violin plot is generated from Monte Carlo permutations, selecting random subsets of GCMs from the provided set.
}
\description{
This function performs Monte Carlo permutations on a distance matrix and produces a violin plot showing the mean distance between subsets of the distance matrix.
}
\examples{
var_names <- c("bio_1", "bio_12")
s <- import_gcms(system.file("extdata", package = "chooseGCM"), var_names = var_names)
study_area <- terra::ext(c(-80, -30, -50, 10)) |> terra::vect(crs="epsg:4326")
montecarlo_gcms(s, var_names, study_area)

}
\seealso{
\code{\link{hclust_gcms}} \code{\link{env_gcms}} \code{\link{kmeans_gcms}}
}
\author{
Luíz Fernando Esser (luizesser@gmail.com)
https://luizfesser.wordpress.com
}
