% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snowMap.R
\name{snowMap}
\alias{snowMap}
\title{Plot John Snow's cholera map.}
\usage{
snowMap(vestry = FALSE, stacked = TRUE, add.cases = TRUE,
  add.landmarks = FALSE, add.pumps = TRUE, add.roads = TRUE,
  add.title = TRUE, ...)
}
\arguments{
\item{vestry}{Logical. TRUE uses the 14 pumps from the map in the Vestry Report. FALSE uses the 13 pumps from the original map.}

\item{stacked}{Logical. Use stacked fatalities.}

\item{add.cases}{Logical. Add observed cases.}

\item{add.landmarks}{Logical. Add landmarks.}

\item{add.pumps}{Logical. Add pumps.}

\item{add.roads}{Logical. Add roads.}

\item{add.title}{Logical. Add title.}

\item{...}{Additional plotting parameters.}
}
\value{
A base R graphics plot.
}
\description{
Uses amended version of Dodson and Tobler's data.
}
\examples{
snowMap()
snowMap(vestry = TRUE, stacked = FALSE)
}
\seealso{
\code{\link{addLandmarks}},
\code{\link{addKernelDensity}},
\code{\link{addLandmarks}},
\code{\link{addPlaguePit}},
\code{\link{addVoronoi}}.
\code{\link{addWhitehead}}
}
