% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-environment.R
\name{chk_environment}
\alias{chk_environment}
\alias{vld_environment}
\title{Check Environment}
\usage{
chk_environment(x, x_name = NULL)

vld_environment(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if environment using

\code{is.environment(x)}
}
\section{Functions}{
\itemize{
\item \code{vld_environment}: Validate Environment
}}

\examples{
# chk_environment
chk_environment(.GlobalEnv)
try(chk_environment(1))
# vld_environment
vld_environment(1)
vld_environment(list(1))
vld_environment(.GlobalEnv)
vld_environment(environment())
}
\seealso{
Other chk_typeof: 
\code{\link{chk_character}()},
\code{\link{chk_double}()},
\code{\link{chk_integer}()},
\code{\link{chk_list}()},
\code{\link{chk_logical}()}
}
\concept{chk_typeof}
