% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-scalar.R
\name{chk_scalar}
\alias{chk_scalar}
\alias{vld_scalar}
\title{Check Scalar}
\usage{
chk_scalar(x, x_name = NULL)

vld_scalar(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if is a vector using

\code{length(x) == 1L}
}
\section{Functions}{
\itemize{
\item \code{vld_scalar}: Validate Scalar
}}

\examples{

# chk_scalar
chk_scalar(1)
chk_scalar(list(1))
try(chk_scalar(1:2))

# vld_scalar
vld_scalar(1)
}
\seealso{
Other chk_scalars: 
\code{\link{chk_datetime}()},
\code{\link{chk_date}()},
\code{\link{chk_number}()},
\code{\link{chk_string}()},
\code{\link{chk_tz}()},
\code{\link{chk_whole_number}()}
}
\concept{chk_scalars}
