% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_chirps.R
\name{get_chirps}
\alias{get_chirps}
\alias{get_chirps.default}
\alias{get_chirps.sf}
\alias{get_chirps.geojson}
\title{Get CHIRPS precipitation data}
\usage{
get_chirps(object, dates, operation = 5, ...)

\method{get_chirps}{default}(object, dates, operation = 5, ...)

\method{get_chirps}{sf}(object, dates, operation = 5, as.sf = FALSE, ...)

\method{get_chirps}{geojson}(object, dates, operation = 5, as.geojson = FALSE, ...)
}
\arguments{
\item{object}{input, an object of class \code{\link[base]{data.frame}} (or
any other object that can be coerced to data.frame), \code{geojson} or 
\code{\link[sf]{sf}}}

\item{dates}{a character of start and end dates in that order in the format
"YYYY-MM-DD"}

\item{operation}{optional, an integer that represents which type of
statistical operation to perform on the dataset}

\item{...}{further arguments passed to \code{\link[sf]{sf}} methods
See details}

\item{as.sf}{logical, returns an object of class \code{\link[sf]{sf}}}

\item{as.geojson}{logical, returns an object of class \code{geojson}}
}
\value{
A data frame of \acronym{CHIRPS} data:
\describe{
  \item{id}{the index for the rows in \code{object}}
  \item{dates}{the dates from which \acronym{CHIRPS} was requested}
  \item{lon}{the longitude as provided in \code{object}}
  \item{lat}{the latitude as provided in \code{object}}
  \item{chirps}{the \acronym{CHIRPS} value in mm}
}
}
\description{
Get daily precipitation data from the "Climate Hazards Group InfraRed
 Precipitation with Station Data" via ClimateSERV \acronym{API} client.
 ClimateSERV works with geojson of type 'Polygon'. The input \code{object}
 is then transformed into polygons with a small buffer area around the point.
}
\details{
\bold{operation}: supported operations are:
 \tabular{rll}{
 \bold{operation}      \tab    \tab \bold{value}\cr
 max                   \tab =  \tab 0\cr
 min                   \tab =  \tab 1\cr
 median                \tab =  \tab 2\cr
 sum                   \tab =  \tab 4\cr
 average               \tab =  \tab 5 (\emph{default value})\cr
 }

\bold{dist}: numeric, buffer distance for each \code{object} coordinate

\bold{nQuadSegs}: integer, number of segments per buffer quadrant
}
\note{
get_chirps may return some warning messages given by 
\code{\link[sf]{sf}}, please look sf documentation for 
possible issues.
}
\examples{
\donttest{
lonlat <- data.frame(lon = c(-55.0281,-54.9857),
                     lat = c(-2.8094, -2.8756))

dates <- c("2017-12-15", "2017-12-31")

dt <- get_chirps(lonlat, dates)

dt

}

}
\references{
Funk C. et al. (2015). Scientific Data, 2, 150066.
 \cr\url{https://doi.org/10.1038/sdata.2015.66}

ClimateSERV \url{https://climateserv.servirglobal.net}
}
