% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_temperatures_from_grids.R
\name{extract_temperatures_from_grids}
\alias{extract_temperatures_from_grids}
\title{Extract temperature information from gridded dataset}
\usage{
extract_temperatures_from_grids(coordinates, grid_format, grid_specifications,
  scenario_year = NA, reference_year = NA, scenario_type = NA,
  labels = NA, temperature_check_args = NULL)
}
\arguments{
\item{coordinates}{numeric vector specifying coordinates for the point location of interest.
These coordinates have to use the same coordinate system as the grids, from which data are to
be extracted. The elements can be named as 'longitude' and 'latitude', or provided as unnamed
elements. In the latter case, the first element is interpreted as the x-coordinate (e.g. longitude
or Easting) and the second element as the y-coordinate (e.g. latitude or Northing).}

\item{grid_format}{character string specifying the type of raster data. See details below.}

\item{grid_specifications}{list of specifications that instruct the function on where to find
the temperature grids. See grid_format descriptions for what is required here.}

\item{scenario_year}{year the temperature scenario is representative of, e.g. 2050, 2080. If the
scenario period is an interval, this should be the median of all years in this interval.}

\item{reference_year}{year of reference for the gridded climate data. This is only important
for relative temperature scenarios. If the reference period is an interval, this should be the
median of all years in this interval.}

\item{scenario_type}{character string specifying whether the climate data contains a relative
or absolute temperature sceanario. Accordingly, this should be 'relative' or 'absolute'. Can also
be NA, which is the default, in which case the function makes a guess on which type applies. This
guess is directed by the temperature_check_args.}

\item{labels}{list of labels to be passed to the labels argument of the resulting temperature_scenario}

\item{temperature_check_args}{list of arguments to be passed to the check_temperature_scenario function.
Check documentation of that function for details.}
}
\value{
temperature scenario object extracted from the grids, consisting of the following elements:
'data' = a data frame with n_intervals elements containing the absolute or relative temperature
information. 'reference_year' = the year the scenario is representative of. 'scenario_type' =
the scenario type ('absolute' or 'relative'); 'labels' = and elements attached to the input
temperature_scenario as an element names 'labels'.

The function generates errors, when problems arise.
}
\description{
Temperature data is often available in gridded format, and records for particular points must
be extracted for work on site-specific issues (such as chill calculation). This function
implements this, for certain types of gridded data.
}
\details{
The following climate data formats are supported: "AFRICLIM" - data downloaded from
https://www.york.ac.uk/environment/research/kite/resources/; "CCAFS" - data downloaded from
http://ccafs-climate.org/data_spatial_downscaling/; "WorldClim" - data downloaded from
http://www.worldclim.org/. All these databases provide separate zipped files for monthly minimum
and monthly maximum temperatures, but they differ slightly in format and structure. If you want to
see additional formats included, please send me a message.
}
\examples{

  coordinates<-c(10.6082,34.9411)
 # grid_specifications<-list(base_folder="D:/DATA/AFRICLIM/GeoTIFF_30s/future_scenarios/",
 #                           minfile="tasmin_rcp45_2055_CCCma-CanESM2_CCCma-CanRCM4_wc30s.zip",
 #                           maxfile="tasmax_rcp45_2055_CCCma-CanESM2_CCCma-CanRCM4_wc30s.zip")
                            
 # extract_temperatures_from_grids(coordinates,grid_format="AFRICLIM",grid_specifications,
 #    scenario_type="relative",scenario_year=2055)
                 
 # grid_specifications<-list(base_folder="D:/DATA/CCAFS_climate/",
 #                           minfile="bcc_csm1_1_rcp2_6_2030s_tmin_30s_r1i1p1_b4_asc.zip",
 #                           maxfile="bcc_csm1_1_rcp2_6_2030s_tmax_30s_r1i1p1_b4_asc.zip")
 #temps<-extract_temperatures_from_grids(coordinates,grid_format="CCAFS",grid_specifications,
 #                                       scenario_type="relative",scenario_year=2035)
 
}
\author{
Eike Luedeling
}
\keyword{utility}
