% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ael02.R
\docType{data}
\name{ael02_main}
\alias{ael02_main}
\alias{ael02_pre}
\alias{ael02}
\title{\code{AEL02} Listing 1 (Default) Listing of Adverse Events.}
\format{
An object of class \code{chevron_l} of length 1.
}
\usage{
ael02_main(
  adam_db,
  dataset = "adae",
  key_cols = c("ID", "ASR"),
  disp_cols = c("AEDECOD", "TRTSDTM", "ASTDY", "ADURN", "AESER", "ASEV", "AREL", "AEOUT",
    "AECONTRT", "AEACN"),
  split_into_pages_by_var = "ACTARM",
  unique_rows = FALSE,
  ...
)

ael02_pre(adam_db, dataset = "adae", arm_var = "ACTARM", ...)

ael02
}
\arguments{
\item{adam_db}{(\code{list} of \code{data.frames}) object containing the \code{ADaM} datasets}

\item{dataset}{(\code{string}) the name of a table in the \code{adam_db} object.}

\item{key_cols}{(\code{character}) names of columns that should be treated as key columns when rendering the listing.
Key columns allow you to group repeat occurrences.}

\item{disp_cols}{(\code{character}) names of non-key columns which should be displayed when the listing is rendered.}

\item{split_into_pages_by_var}{(\code{character} or \code{NULL}) the name of the variable to split the listing by.}

\item{unique_rows}{(\code{flag}) whether to keep only unique rows in listing.}

\item{...}{not used.}

\item{arm_var}{(\code{string}) variable used for column splitting}
}
\value{
the main function returns an \code{rlistings} or a \code{list} object.

the preprocessing function returns a \code{list} of \code{data.frame}.
}
\description{
\code{AEL02} Listing 1 (Default) Listing of Adverse Events.
}
\section{Functions}{
\itemize{
\item \code{ael02_main()}: Main TLG function

\item \code{ael02_pre()}: Preprocessing

}}
\examples{
res <- run(ael02, syn_data)
}
\keyword{datasets}
