% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/egt05_qtcat.R
\docType{data}
\name{egt05_qtcat_main}
\alias{egt05_qtcat_main}
\alias{egt05_qtcat_pre}
\alias{egt05_qtcat_post}
\alias{egt05_qtcat}
\title{\code{EGT05_QTCAT} ECG Actual Values and Changes from Baseline by Visit Table.}
\format{
An object of class \code{chevron_t} of length 1.
}
\usage{
egt05_qtcat_main(
  adam_db,
  arm_var = "ACTARM",
  lbl_overall = NULL,
  summaryvars = c("AVALCAT1", "CHGCAT1"),
  row_split_var = NULL,
  visitvar = "AVISIT",
  page_var = NULL,
  ...
)

egt05_qtcat_pre(adam_db, ...)

egt05_qtcat_post(tlg, prune_0 = TRUE, ...)

egt05_qtcat
}
\arguments{
\item{adam_db}{(\code{list} of \code{data.frames}) object containing the \code{ADaM} datasets}

\item{arm_var}{(\code{string}) variable used for column splitting}

\item{lbl_overall}{(\code{string}) label used for overall column, if set to \code{NULL} the overall column is omitted}

\item{summaryvars}{(\code{character}) variables to be analyzed. The label attribute of the corresponding column in \code{adeg}
table of \code{adam_db} is used as name.}

\item{row_split_var}{(\code{character}) additional row split variables.}

\item{visitvar}{(\code{string}) typically \code{"AVISIT"} or user-defined visit incorporating \code{"ATPT"}.}

\item{page_var}{(\code{string}) variable name prior to which the row split is by page.}

\item{...}{not used.}

\item{tlg}{(\code{TableTree}, \code{Listing} or \code{ggplot}) object typically produced by a \code{main} function.}

\item{prune_0}{(\code{flag}) remove 0 count rows}
}
\value{
the main function returns an \code{rtables} object.

the preprocessing function returns a \code{list} of \code{data.frame}.

the postprocessing function returns an \code{rtables} object or an \code{ElementaryTable} (null report).
}
\description{
The \code{EGT05_QTCAT} table summarizes several electrocardiogram parameters and their evolution
throughout the study.
}
\details{
\itemize{
\item The \verb{Value at Visit} column, displays the categories of the specific \code{"PARAMCD"} value for patients.
\item The \verb{Change from Baseline} column, displays the categories of the specific \code{"PARAMCD"} value
change from baseline for patients.
\item Remove zero-count rows unless overridden with \code{prune_0 = FALSE}.
\item Split columns by arm, typically \code{"ACTARM"}.
\item Does not include a total column by default.
\item Sorted based on factor level; by chronological time point given by \code{"AVISIT"}
or user-defined visit incorporating \code{"ATPT"}.
Re-level to customize order.
\item Please note that it is preferable to convert \code{summaryvars} to factor.
}
}
\section{Functions}{
\itemize{
\item \code{egt05_qtcat_main()}: Main TLG function

\item \code{egt05_qtcat_pre()}: Preprocessing

\item \code{egt05_qtcat_post()}: Postprocessing

}}
\note{
\itemize{
\item \code{adam_db} object must contain an \code{adeg} table with column specified in \code{visitvar}.
For \code{summaryvars}, please make sure \code{AVALCAT1} and \code{CHGCAT1} columns existed in input data sets.
}
}
\examples{
run(egt05_qtcat, syn_data)
}
\keyword{datasets}
