% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkOS.R
\name{checkOS}
\alias{assertOS}
\alias{assert_os}
\alias{checkOS}
\alias{expect_os}
\alias{testOS}
\alias{test_os}
\title{Check the operating system}
\usage{
checkOS(os)

assertOS(os, add = NULL, .var.name = NULL)

assert_os(os, add = NULL, .var.name = NULL)

testOS(os)

test_os(os)

expect_os(os, info = NULL, label = NULL)
}
\arguments{
\item{os}{[\code{character(1)}]\cr
Check the operating system to be in a set with possible elements \dQuote{windows},
\dQuote{mac}, \dQuote{linux} and \dQuote{solaris}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link{AssertCollection}}.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link{vname}}.}

\item{info}{[character(1)]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[\code{character(1)}]\cr
Name of the checked object to print in messages. Defaults to
the heuristic implemented in \code{\link{vname}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions return \code{TRUE}. If the check
 is not successful, \code{assertOS}/\code{assert_os}
 throws an error message, \code{testOS}/\code{test_os}
 returns \code{FALSE},
 and \code{checkOS} returns a string with the error message.
 The function \code{expect_os} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check the operating system
}
\examples{
testOS("linux")
}

