% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/checkPathForOutput.r
\name{checkPathForOutput}
\alias{assertPathForOutput}
\alias{checkPathForOutput}
\alias{expect_path_for_output}
\alias{testPathForOutput}
\title{Check file path for later output}
\usage{
checkPathForOutput(x, overwrite = FALSE)

assertPathForOutput(x, overwrite = FALSE, add = NULL, .var.name)

testPathForOutput(x, overwrite = FALSE)

expect_path_for_output(x, overwrite = FALSE, info = NULL, label = NULL)
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{overwrite}{[\code{logical(1)}]\cr
If \code{TRUE}, an exising file in place is allowed if it
it is both readable and writeable.
Default is \code{FALSE}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertions. See \code{\link{AssertCollection}}.}

\item{.var.name}{[character(1)]\cr
Name for \code{x}. Defaults to a heuristic to determine
the name using \code{\link[base]{deparse}} and \code{\link[base]{substitute}}.}

\item{info}{[character(1)]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[character(1)]\cr
Same as \code{.var.name}, but passed down to \code{\link[testthat]{expect_that}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, all functions return \code{TRUE}.
 If the check is not successful, \code{assertPathForOutput} throws an error message,
 \code{testPathForOutput} returns \code{FALSE}, \code{checkPathForOutput} returns
 a string with the error message. The function \code{expect_path_for_output} will
 return an \code{\link[testthat]{expectation}}.
}
\description{
Check whether a file path can later be safely used to create a file and write to it.

This is checked:
\itemize{
 \item{Does \code{dirname(x)} exist?}
 \item{Does no file under path \code{x} exist?}
 \item{Is \code{dirname(x)} writeable?}
}
Paths are relative to the current working directory.
}
\examples{
# Can we create a file in the tempdir?
testPathForOutput(file.path(tempdir(), "process.log"))
}
\seealso{
Other filesystem: \code{\link{assertAccess}},
  \code{\link{checkAccess}}, \code{\link{expect_access}},
  \code{\link{testAccess}}; \code{\link{assertDirectory}},
  \code{\link{checkDirectory}},
  \code{\link{expect_directory}},
  \code{\link{testDirectory}}; \code{\link{assertFile}},
  \code{\link{checkFile}}, \code{\link{expect_file}},
  \code{\link{testFile}}
}

