% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factors.R
\name{factor_}
\alias{factor_}
\alias{as_factor}
\alias{levels_factor}
\alias{levels_used}
\alias{levels_unused}
\alias{used_levels}
\alias{unused_levels}
\alias{levels_add_na}
\alias{levels_drop_na}
\alias{levels_drop}
\alias{levels_reorder}
\title{A cheaper version of \code{factor()} along with cheaper utilities}
\usage{
factor_(
  x = integer(),
  levels = NULL,
  order = TRUE,
  na_exclude = TRUE,
  ordered = is.ordered(x)
)

as_factor(x)

levels_factor(x)

levels_used(x)

levels_unused(x)

used_levels(x)

unused_levels(x)

levels_add_na(x, name = NA, where = c("last", "first"))

levels_drop_na(x)

levels_drop(x)

levels_reorder(x, order_by, decreasing = FALSE)
}
\arguments{
\item{x}{A vector.}

\item{levels}{Optional factor levels.}

\item{order}{Should factor levels be sorted? Default is \code{TRUE}.
It typically is faster to set this to \code{FALSE}, in which case the levels
are sorted by order of first appearance.}

\item{na_exclude}{Should \code{NA} values be excluded from the factor levels?
Default is \code{TRUE}.}

\item{ordered}{Should the result be an ordered factor?}

\item{name}{Name of \code{NA} level.}

\item{where}{Where should \code{NA} level be placed? Either first or last.}

\item{order_by}{A vector to order the levels of \code{x} by using the medians of
\code{order_by}.}

\item{decreasing}{Should the reordered levels be in decreasing order?
Default is \code{FALSE}.}
}
\value{
A \code{factor} or \code{character} in the case of \code{levels_used} and \code{levels_unused}.
}
\description{
A fast version of \code{factor()} using the collapse package. \cr

There are some additional utilities, most of which begin with the prefix
'levels_', such as
\code{as_factor()} which is an efficient way to coerce both vectors and factors,
\code{levels_factor()} which returns the levels of a factor, as a factor,
\code{levels_used()} which returns the used levels of a factor,
\code{levels_unused()} which returns the unused levels of a factor,
\code{levels_add_na()} which adds an explicit \code{NA} level,
\code{levels_drop_na()} which drops the \code{NA} level,
\code{levels_drop()} which drops unused factor levels,
and finally \code{levels_reorder()} which reorders the levels of \code{x}
based on \code{y} using the ordered median values of \code{y} for each level.
}
\details{
This operates similarly to \code{collapse::qF()}. \cr
The main difference internally is that \code{collapse::funique()} is used
and therefore s3 methods can be written for it. \cr
Furthermore, for date-times \code{factor_} differs in that it differentiates
all instances in time whereas \code{factor} differentiates calendar times.
Using a daylight savings example where the clocks go back: \cr
\code{factor(as.POSIXct(1729984360, tz = "Europe/London") + 3600 *(1:5))}
produces 4 levels whereas \cr
\code{factor_(as.POSIXct(1729984360, tz = "Europe/London") + 3600 *(1:5))}
produces 5 levels.
}
