% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_summary_print.R
\name{plot.chandwich}
\alias{plot.chandwich}
\title{Plot diagnostics for a chandwich object}
\usage{
\method{plot}{chandwich}(x, y, type = 1, legend = length(type) > 1, legend_pos = "topleft", ...)
}
\arguments{
\item{x}{an object of class "chandwich", a result of a call to
\code{\link{adjust_loglik}}.}

\item{y}{Not used.}

\item{type}{An integer vector, a subset of the numbers \code{1:4}.
Indicates which loglikelihoods to plot: \code{1} for \code{"vertical"}
adjustment; \code{2} for \code{"cholesky"} (horizontal adjustment);
\code{3} for \code{"spectral"} (horizontal adjustment); \code{4}
for no adjustment, i.e. based on the independence loglikelihood.}

\item{legend}{A logical scalar or a character vector.  If this is
supplied then a legend is added to the plot.  If \code{legend} is a
character vector then it is used as the argument \code{legend}
to \code{\link[graphics]{legend}}.  Otherwise, i.e. if
\code{legend = TRUE} then the argument \code{type} is used.}

\item{legend_pos}{The position of the legend (if required) specified using
the argument \code{x} in \code{\link[graphics]{legend}}.}

\item{...}{Additional arguments passed to \code{\link[graphics]{matplot}}
  or \code{\link[graphics]{legend}}.  The arguments \code{col}, \code{lty}
  and \code{lwd} will be used (in a consistent way) by both
  \code{\link[graphics]{matplot}} and \code{\link[graphics]{legend}}.

  If the argument \code{xlim} to \code{\link[graphics]{matplot}} is not
  supplied then the MLE minus (for \code{lower}) or plus (for \code{upper})
  standard errors is used.  If \code{type} does not include 4 then adjusted
  standard errors are used.  Otherwise, the larger of the adjusted and
  unadjusted standard errors are used.}
}
\value{
Nothing is returned.
}
\description{
\code{plot} method for class "chandwich".  Only applicable to an object
\code{x} for which \code{attr(x, "p_current") = 1}, i.e. a model with
one free parameter.
}
\examples{
# ------------------------- Binomial model, rats data ----------------------

# Contributions to the independence loglikelihood
binom_loglik <- function(prob, data) {
  if (prob < 0 || prob > 1) {
    return(-Inf)
  }
  return(dbinom(data[, "y"], data[, "n"], prob, log = TRUE))
}
rat_res <- adjust_loglik(loglik = binom_loglik, data = rats, par_names = "p")

# Vertically adjusted loglikelihood only
plot(rat_res)
# Three adjusted loglikelihoods and the independence loglikelihood
plot(rat_res, type = 1:4)
# Plot over (0,1) and reposition the legend
plot(rat_res, type = 1:4, xlim = c(0, 1), legend_pos = "bottom")
}
\seealso{
\code{\link{adjust_loglik}} to adjust a user-supplied
  loglikelihood function.

\code{\link{summary.chandwich}} for maximum likelihood estimates
  and unadjusted and adjusted standard errors.

\code{\link{conf_intervals}} and \code{\link{plot.confint}} to
  plot confidence intervals for individual parameters.

\code{\link{conf_region}} and \code{\link{plot.confreg}} to
  plot a confidence region for a pair of parameters.
}
