% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cff_git_hook.R
\name{cff_git_hook}
\alias{cff_git_hook}
\alias{cff_git_hook_install}
\alias{cff_git_hook_remove}
\title{Use a git pre-commit hook \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}}
\usage{
cff_git_hook_install()

cff_git_hook_remove()
}
\value{
Invisible. This function is called for its side effects.
}
\description{
Install a
\href{https://git-scm.com/book/en/v2/Customizing-Git-Git-Hooks#_committing_workflow_hooks}{pre-commit hook}
that remembers you to update your \code{CITATION.cff} file. This is a wrapper of
\code{\link[usethis:use_git_hook]{usethis::use_git_hook()}}.
}
\details{
This function would install a pre-commit hook using
\code{\link[usethis:use_git_hook]{usethis::use_git_hook()}}.

A pre-commit hook is a script that identifies  simple issues before
submission to code review. This pre-commit hook would warn you if any of the
following conditions are met:
\itemize{
\item You included in a commit your \code{DESCRIPTION} or \code{inst/CITATION} file, you
are not including your \code{CITATION.cff} and the \code{CITATION.cff} file is
"older" than any of your \code{DESCRIPTION} or \code{inst/CITATION} file.
\item You have updated your \code{CITATION.cff} but you are not including it on
your commit.
}
}
\section{A word of caution}{
The pre-commit hook may prevent you to commit if you are not updating your
\code{CITATION.cff}. However, the mechanism of detection is not perfect and would
be triggered also even if you have tried to update your \code{CITATION.cff} file.

This is typically the case when you have updated your \code{DESCRIPTION} or
\code{inst/CITATION} files but those changes doesn't make a change on your
\code{CITATION.cff} file (i.e. you are including new dependencies).

In those cases, you can override the check running \verb{git commit --no-verify}
on the terminal.

If you are using \strong{RStudio} you can run also this command from a \strong{R}
script by selecting that line and sending it to the terminal using:
\itemize{
\item Windows & Linux: \code{Ctrl+Alt+Enter}.
\item Mac: \code{Cmd+Option+Return}.
}
}

\section{Removing the git pre-commit hook}{
You can remove the pre-commit hook by running \code{cff_git_hook_remove()}.
}

\examples{
\dontrun{
cff_git_hook_install()
}

}
\seealso{
\itemize{
\item \code{\link[usethis:use_git_hook]{usethis::use_git_hook()}}, that is the underlying function used by
\code{cff_git_hook_install()}.
\item \code{\link[usethis:use_git]{usethis::use_git()}} and related function of \CRANpkg{usethis} for using
Git with \strong{R} packages.
}

Other Git/GitHub helpers provided by \CRANpkg{cffr}:
\code{\link{cff_gha_update}()}
}
\concept{git}
