% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_citation.R
\name{write_citation}
\alias{write_citation}
\title{Create a \code{inst/CITATION} file}
\usage{
write_citation(
  x,
  file = "./inst/CITATION",
  append = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{It could be
\itemize{
\item A \code{bibentry} object created with \code{\link[=cff_to_bibtex]{cff_to_bibtex()}}, \code{\link[=citation]{citation()}} or
\code{\link[=bibentry]{bibentry()}}
\item Any of the valid inputs of \code{\link[=cff_to_bibtex]{cff_to_bibtex()}}:
\itemize{
\item A missing value. That would retrieve the DESCRIPTION file on your
in-development package.
\item An existing \code{\link{cff}} object,
\item Path to a CITATION.cff file (\code{"*/CITATION.cff*"}),
\item The name of an installed package (\code{"jsonlite"}), or
\item Path to a DESCRIPTION file (\code{"*/DESCRIPTION*"}).
}
}}

\item{file}{Name of the file to write.}

\item{append}{Whether to append the entries to an existing file or not.}

\item{verbose}{Display informative messages}

\item{...}{
  Arguments passed on to \code{\link[=cff_to_bibtex]{cff_to_bibtex}}
  \describe{
    \item{\code{what}}{Fields to extract. The value could be:
\itemize{
\item \code{preferred}: This would create a single entry with the main citation
info of the package.
\item \code{references}: Extract all the entries on \code{references}.
\item \code{all}: A combination of the previous two options. This would extract
both the preferred citation info and the references.
}}
  }}
}
\value{
Writes an \code{inst/CITATION} file and (invisibly) returns the
\code{bibentry} object that has been written to the file.
}
\description{
Creates a R CITATION file (inst/CITATION) from the metadata of a
CITATION.cff file or \code{cff} object.
}
\details{
For security reasons, if the file already exists the function would create
a backup copy on the same directory.
}
\examples{
# Use a system file
f <- system.file("examples/preferred-citation-book.cff", package = "cffr")

# Write to tmp dir
out <- file.path(tempdir(), "CITATION")
write_citation(f, file = out)

# Check by reading, use meta object

meta <- packageDescription("cffr")
meta$Encoding <- "UTF-8"

utils::readCitationFile(out, meta)


# Append to the same file
bib2 <- citation()
write_citation(bib2, file = out, append = TRUE)

utils::readCitationFile(out, meta)
}
\references{
R Core Team (2023). "CITATION files." In Writing R Extensions, chapter 1.9,
R version 4.3.0 (2023-04-21) edition.
\url{https://cran.r-project.org/doc/manuals/R-exts.html#CITATION-files}.
}
\seealso{
\code{\link[=bibentry]{bibentry()}} and \code{style} argument.

Other bibtex: 
\code{\link{cff_from_bibtex}()},
\code{\link{cff_to_bibtex}()},
\code{\link{encoded_utf_to_latex}()},
\code{\link{write_bib}()}
}
\concept{bibtex}
