% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_players.R
\name{cfbd_player_usage}
\alias{cfbd_player_usage}
\title{\strong{Get player usage metrics}}
\usage{
cfbd_player_usage(
  year = 2019,
  team = NULL,
  conference = NULL,
  position = NULL,
  athlete_id = NULL,
  excl_garbage_time = FALSE
)
}
\arguments{
\item{year}{(\emph{Integer} required, default 2019): Year, 4 digit format (\emph{YYYY}).}

\item{team}{(\emph{String} optional): Team - Select a valid team, D1 football}

\item{conference}{(\emph{String} optional): Conference abbreviation - Select a valid FBS conference
Conference abbreviations P5: ACC, B12, B1G, SEC, PAC
Conference abbreviations G5 and FBS Independents: CUSA, MAC, MWC, Ind, SBC, AAC}

\item{position}{(\emph{string} optional): Position of the player you are searching for.
Position Group  - options include:
\itemize{
\item Offense: QB, RB, FB, TE,  OL, G, OT, C, WR
\item Defense: DB, CB, S, LB,  DE, DT, NT, DL
\item Special Teams: K, P, LS, PK
}}

\item{athlete_id}{(\emph{Integer} optional): Athlete ID filter for querying a single athlete
Can be found using the \code{\link[=cfbd_player_info]{cfbd_player_info()}} function.}

\item{excl_garbage_time}{(\emph{Logical} default FALSE): Select whether to exclude Garbage Time (TRUE/FALSE)}
}
\value{
\code{\link[=cfbd_player_usage]{cfbd_player_usage()}} - A data frame with 14 variables:
\describe{
\item{\code{season}: integer.}{Player usage season.}
\item{\code{athlete_id}: character.}{Referencing athlete id.}
\item{\code{name}: character.}{Athlete name.}
\item{\code{position}: character.}{Athlete position.}
\item{\code{team}: character.}{Team name.}
\item{\code{conference}: character.}{Conference of team.}
\item{\code{usg_overall}: double.}{Player usage of overall offense.}
\item{\code{usg_pass}: double.}{Player passing usage percentage.}
\item{\code{usg_rush}: double.}{Player rushing usage percentage.}
\item{\code{usg_1st_down}: double.}{Player first down usage percentage.}
\item{\code{usg_2nd_down}: double.}{Player second down usage percentage.}
\item{\code{usg_3rd_down}: double.}{Player third down usage percentage.}
\item{\code{usg_standard_downs}: double.}{Player standard down usage percentage.}
\item{\code{usg_passing_downs}: double.}{Player passing down usage percentage.}
}
}
\description{
\strong{Get player usage metrics}
}
\examples{
\donttest{
  try(cfbd_player_usage(year = 2019, position = "WR", team = "Florida State"))
}

}
\keyword{Player}
\keyword{Usage}
