% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proportional_hazards-glmnet.R
\name{survival_prob_coxnet}
\alias{survival_prob_coxnet}
\title{A wrapper for survival probabilities with coxnet models}
\usage{
survival_prob_coxnet(
  object,
  new_data,
  eval_time,
  time = deprecated(),
  output = "surv",
  penalty = NULL,
  ...
)
}
\arguments{
\item{object}{A fitted \verb{_coxnet} object.}

\item{new_data}{Data for prediction.}

\item{eval_time}{A vector of integers for prediction times.}

\item{time}{Deprecated in favor of \code{eval_time}. A vector of integers for prediction times.}

\item{output}{One of "surv" or "haz".}

\item{penalty}{Penalty value(s).}

\item{...}{Options to pass to \code{\link[survival:survfit]{survival::survfit()}}.}
}
\value{
A tibble with a list column of nested tibbles.
}
\description{
A wrapper for survival probabilities with coxnet models
}
\examples{
cox_mod <- proportional_hazards(penalty = 0.1) \%>\%
  set_engine("glmnet") \%>\%
  fit(Surv(time, status) ~ ., data = lung)
survival_prob_coxnet(cox_mod, new_data = lung[1:3, ], eval_time = 300)
}
\keyword{internal}
