% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rule.R
\name{rule}
\alias{rule}
\title{Add a cell type rule.}
\usage{
rule(
  obj,
  class,
  feature,
  operator = ">",
  threshold,
  parent = NULL,
  use_CP10K = TRUE
)
}
\arguments{
\item{obj}{A cellpypes object, see section \strong{cellpypes Objects} below.}

\item{class}{Character scalar with the class name. Typically,
cellpypes classes
are literature cell types ("T cell") or any subpopulation of interest
("CD3E+TNF+LAG3-").}

\item{feature}{Character scalar naming the gene you'd like to threshold.
Must be a row name in \code{obj$raw}.}

\item{operator}{One of \code{c(">","<")}. Use ">" for positive (CD3E+) and
"<" for negative markers (MS4A1-).}

\item{threshold}{Numeric scalar with the expression threshold separating positive
from negative cells.
Experiment with this value, until expression and selected cells agree well
in UMAP (see examples on
\href{https://github.com/FelixTheStudent/cellpypes}{gitHub}).}

\item{parent}{Character scalar with the parent class
(e.g. "T cell" for "Cytotoxic T cells").
Only has to be specified once per class (else most recent one is taken),
and defaults to
"..root.." if NULL is passed in all rules.}

\item{use_CP10K}{If TRUE, \code{threshold} is taken to be
counts per 10 thousand UMI counts, a measure for RNA molecule fractions.
We recommend CP10K for human intuition (1 CP10K is roughly 1 UMI per cell),
but the results are the exact same whether you use
\code{threshold=1,CP10K=TRUE} or
\code{threshold=1e-4,CP10K=FALSE}.}
}
\value{
\code{obj} is returned, but with the rule and class stored in
\code{obj$rules} and \code{obj$classes}, to be used by
\link[cellpypes]{classify}.
}
\description{
This is the heart of cellpypes and best used by piping from
one rule into the next
with \verb{magrittr::\%>\%}. Check out examples at
\href{https://github.com/FelixTheStudent/cellpypes}{gitHub})!
}
\details{
Calling \code{rule} is computationally cheap because it only stores
the cell type rule while all computations
happen in \link[cellpypes]{classify}.
If you have classes with multiple rules, the most recent \code{parent} and
\code{feature}-\code{threshold} combination counts.
It is ok to mix rules with and without \code{use_CP10K=TRUE}.
}
\section{cellpypes Objects}{

A cellpypes object is a \link[base]{list} with four slots:
\itemize{
\item{\code{raw }}{(sparse) matrix with genes in rows, cells in columns}
\item{\code{totalUMI }}{the colSums of obj$raw}
\item{\code{embed }}{two-dimensional embedding of the cells, provided as data.frame
or tibble with two columns and one row per cell.}
\item{\code{neighbors }}{index matrix with one row per cell and k columns, where
k is the number of nearest neighbors (we recommend 15<k<100, e.g. k=50).
Here are two ways to get the neighbors index matrix:
\itemize{
\item Use \code{find_knn(featureMatrix)$idx}, where featureMatrix could be
principal components, latent variables or normalized genes (features in
rows, cells in columns).
\item use \code{as(seurat@graphs[["RNA_nn"]], "dgCMatrix")> .1} to extract
the kNN
graph computed on RNA. The \code{> .1} ensures this also works with RNA_snn,
wknn/wsnn or any other
available graph – check with \code{names(seurat@graphs)}.
}
}
}
}

\examples{
# T cells are CD3E+:
obj <- rule(simulated_umis, "T", "CD3E", ">", .1)
# T cells are MS4A1-:
obj <- rule(obj, "T", "MS4A1", "<", 1)
# Tregs are a subset of T cells:
obj <- rule(obj, "Treg", "FOXP3", ">", .1, parent="T") 

}
\seealso{
To have nicely formatted code in the end, copy the output of
\code{pype_code_template()} to your script and start editing.
}
