% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ced_enc_detect}
\alias{ced_enc_detect}
\title{Detect Encoding}
\usage{
ced_enc_detect(x, enc_hint = NULL, lang_hint = NULL)
}
\arguments{
\item{x}{Raw or character vector.}

\item{enc_hint}{Character vector with encoding hint.}

\item{lang_hint}{Character vector with langauge code hint.}
}
\value{
Character vector with suggested encodings.
}
\description{
Detect charset encoding of the character or raw vector.
}
\examples{
# detect character vector with ASCII strings
ascii <- "I can eat glass and it doesn't hurt me."
ced_enc_detect(ascii)
ced_enc_detect(charToRaw(ascii))

# detect character vector with UTF-8 strings
utf8 <- "\u4e0b\u5348\u597d"
print(utf8)
ced_enc_detect(utf8)
ced_enc_detect(charToRaw(utf8))

# path to examples
ex_path <- system.file("test.txt", package = "ced")
ex_txt <- read.dcf(ex_path, all = TRUE)

# russian text
print(ex_txt[["France"]])
ced_enc_detect(ex_txt[["Russian"]])
ced_enc_detect(iconv(ex_txt[["Russian"]], "utf8", "ibm866"))
ced_enc_detect(iconv(ex_txt[["Russian"]], "utf8", "windows-1251"))
ced_enc_detect(iconv(ex_txt[["Russian"]], "utf8", "koi8-r"))

# chinese text
print(ex_txt[["Chinese"]])
ced_enc_detect(ex_txt[["Chinese"]])
ced_enc_detect(iconv(ex_txt[["Chinese"]], "utf8", "gb18030"))

# korean text
print(ex_txt[["Korean"]])
ced_enc_detect(ex_txt[["Korean"]])
ced_enc_detect(iconv(ex_txt[["Korean"]], "utf8", "uhc"))
ced_enc_detect(iconv(ex_txt[["Korean"]], "utf8", "iso-2022-kr"))

# japanese text
print(ex_txt[["Japanese"]])
ced_enc_detect(ex_txt[["Japanese"]])
ced_enc_detect(iconv(ex_txt[["Japanese"]], "utf8", "shift_jis"))
ced_enc_detect(iconv(ex_txt[["Japanese"]], "utf8", "iso-2022-jp"))


\donttest{
# detect encoding of the web pages content
if (require("curl")) {
  detect_enc_url <- function(u) ced_enc_detect(curl_fetch_memory(u)$content)
  detect_enc_url("https://www.corriere.it")
  detect_enc_url("https://www.vk.com")
  detect_enc_url("https://www.qq.com")
  detect_enc_url("https://kakaku.com")
  detect_enc_url("https://etoland.co.kr")
}
}
}
