% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ccdf_testing.R
\name{ccdf_testing}
\alias{ccdf_testing}
\title{Main function to perform complex hypothesis testing using (un)conditional independence test}
\usage{
ccdf_testing(
  exprmat = NULL,
  variable2test = NULL,
  covariate = NULL,
  distance = c("L2", "L1", "L_sup"),
  test = c("asymptotic", "permutations", "dist_permutations"),
  method = c("linear regression", "logistic regression", "RF"),
  fast = TRUE,
  n_perm = 100,
  n_perm_adaptive = c(100, 150, 250, 500),
  thresholds = c(0.1, 0.05, 0.01),
  parallel = TRUE,
  n_cpus = NULL,
  adaptive = FALSE,
  space_y = FALSE,
  number_y = ncol(exprmat)
)
}
\arguments{
\item{exprmat}{a data frame of size \code{G x n} containing the
preprocessed expressions from \code{n} samples (or cells) for \code{G}
genes. Default is \code{NULL}.}

\item{variable2test}{a data frame of numeric or factor vector(s) 
of size \code{n} containing the variable(s) to be tested (the condition(s))}

\item{covariate}{a data frame of numeric or factor vector(s) 
of size \code{n} containing the covariate(s)}

\item{distance}{a character string indicating which distance to use to
compute the test, either \code{'L2'}, \code{'L1'} or 
\code{'L_sup'}, when \code{method} is \code{'dist_permutations'}, 
Default is \code{'L2'}.}

\item{test}{a character string indicating which method to use to
compute the test, either \code{'asymptotic'}, \code{'permutations'} or 
\code{'dist_permutations'}. \code{'dist_permutations'} allows to compute
the distance between the CDF and the CCDF or two CCDFs.
Default is \code{'asymptotic'}.}

\item{method}{a character string indicating which method to use to
compute the CCDF, either \code{'linear regression'}, \code{'logistic regression'}
and  \code{'permutations'} or \code{'RF'} for Random Forests.
Default is \code{'linear regression'} since it is the method used in the test.}

\item{fast}{a logical flag indicating whether the fast implementation of
logistic regression should be used. Only if \code{'dist_permutations'} is specified.
Default is \code{TRUE}.}

\item{n_perm}{the number of permutations. Default is \code{100}.}

\item{n_perm_adaptive}{a vector of the increasing numbers of 
adaptive permutations when \code{adaptive} is \code{TRUE}. 
\code{length(n_perm_adaptive)} should be equal to \code{length(thresholds)+1}. 
Default is \code{c(0.1,0.05,0.01)}.}

\item{thresholds}{a vector of the decreasing thresholds to compute
adaptive permutations when \code{adaptive} is \code{TRUE}. 
\code{length(thresholds)} should be equal to \code{length(n_perm_adaptive)-1}. 
Default is \code{c(100,150,250,500)}.}

\item{parallel}{a logical flag indicating whether parallel computation
should be enabled. Default is \code{TRUE}.}

\item{n_cpus}{an integer indicating the number of cores to be used when
\code{parallel} is \code{TRUE}.
Default is \code{parallel::detectCores() - 1}.}

\item{adaptive}{a logical flag indicating whether adaptive permutations
should be performed. Default is \code{FALSE}.}

\item{space_y}{a logical flag indicating whether the y thresholds are spaced. 
When \code{space_y} is \code{TRUE}, a regular sequence between the minimum and 
the maximum of the observations is used. Default is \code{FALSE}.}

\item{number_y}{an integer value indicating the number of y thresholds (and therefore
the number of regressions) to perform the test. Default is \code{ncol(exprmat)}.}
}
\value{
A list with the following elements:\itemize{
  \item \code{which_test}: a character string carrying forward the value of
  the '\code{which_test}' argument indicating which test was performed (either
  'asymptotic','permutations','dist_permutations').
  \item \code{n_perm}: an integer carrying forward the value of the
  '\code{n_perm}' argument or '\code{n_perm_adaptive}' indicating the number of permutations performed
  (\code{NA} if asymptotic test was performed).
  \item \code{pval}: computed p-values. A data frame with one raw for
  each gene, and with 2 columns: the first one '\code{raw_pval}' contains
  the raw p-values, the second one '\code{adj_pval}' contains the FDR adjusted p-values
  using Benjamini-Hochberg correction.
}
}
\description{
Main function to perform complex hypothesis testing using (un)conditional independence test
}
\examples{

X <- as.factor(rbinom(n=100, size = 1, prob = 0.5))
Y <- t(replicate(10, ((X==1)*rnorm(n = 50,0,1)) + ((X==0)*rnorm(n = 50,0.5,1))))
res_asymp <- ccdf_testing(exprmat=data.frame(Y=Y), 
variable2test=data.frame(X=X), test="asymptotic",
n_cpus=1)$pvals # asymptotic test
}
\references{
Gauthier M, Agniel D, Thiébaut R & Hejblum BP (2019).
Distribution-free complex hypothesis testing for single-cell RNA-seq differential expression analysis, *bioRxiv* 445165.
[DOI: 10.1101/2021.05.21.445165](https://doi.org/10.1101/2021.05.21.445165).
}
