% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemical-APIs-batch.R
\name{get_chemical_synonym_batch}
\alias{get_chemical_synonym_batch}
\title{Get chemical synonym batch}
\usage{
get_chemical_synonym_batch(
  DTXSID = NULL,
  API_key = NULL,
  rate_limit = 0L,
  verbose = FALSE
)
}
\arguments{
\item{DTXSID}{A list of chemical identifier DTXSIDs}

\item{API_key}{The user-specific API key.}

\item{rate_limit}{The number of seconds to wait between requests.}

\item{verbose}{A logical indicating if some “progress report” should be given.}
}
\value{
A named list of lists containing synonym information for each input
DTXSID.
}
\description{
Get chemical synonym batch
}
\examples{
\dontshow{if (has_ccte_key() & is.na(ccte_key() == 'FAKE_KEY')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Pull synonyms for multiple chemicals
dtxsid <- c('DTXSID7020182', 'DTXSID2021315')
batch_synonyms <- get_chemical_synonym_batch(DTXSID = dtxsid)
\dontshow{\}) # examplesIf}
}
