% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean_balance.R
\name{mean_bal}
\alias{mean_bal}
\title{Standardized absolute mean difference calculations}
\usage{
mean_bal(data, weights = NULL, ...)
}
\arguments{
\item{data}{Either a data.frame, matrix, or object of class DataSim}

\item{weights}{An object of class causalWeights or a list with slots w0 and w1.}

\item{...}{Additional arguments passed to the function to know which covariates are to be balanced ("balance.covariates"), and treatment indicator ("treatment.indicator"). These can be column names or numbers. These arguments are not needed if using the causalOT DataSim class.}
}
\value{
A vector of mean balances
}
\description{
This function will calculate the difference in means between treatment groups standardized by the pooled standard-deviation of the respective covariates.
}
\examples{

n <- 100
p <- 6
x0 <- matrix(rnorm(2*n * p), 2*n, p)
x1 <- matrix(rnorm(n * p), n, p)
weights <- list(w0 = rep(1/(2*n), 2 * n), w1 = rep(1/n, n))
data <- cbind(rbind(x0,x1), z = c(rep(0,2*n), rep(1, n)))
colnames(data) <- c(paste0("x", 1:p), "z")
mb <- mean_bal(data, weights, balance.covariates = paste0("x", 1:p), 
               treatment.indicator = "z")
print(mb)
}
