% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{sMIDUS}
\alias{sMIDUS}
\title{Synthetic Data Generated Based on the Midlife Development in the U.S. (MIDUS) Study}
\format{
A data frame containing the following variables.
\describe{
\item{health:}{ cardiovascular health score.}
\item{racesex:}{ race-gender groups with four levels (1: White men, 2: White women, 3: Black men, 4: Black women).}
\item{lowchildSES:}{ socioeconomic status (SES) in the childhood.}
\item{abuse:}{ adverse experience in the childhood.}
\item{edu:}{ education level.}
\item{age:}{ age.}
\item{stroke:}{ genetic vulnerability with a value of 0 or 1.}
\item{T2DM:}{ genetic vulnerability with a value of 0 or 1.}
\item{heart:}{ genetic vulnerability with a value of 0 or 1.}
}
}
\usage{
sMIDUS
}
\description{
This is a synthetic dataset that includes variables from the Midlife Development
in the U.S. (MIDUS) study. It has been artificially generated based on the actual
MIDUS data, which is not publicly available due to confidentiality concerns.
The synthetic data set consists of 1948 rows and 9 columns, with no missing values.
}
\details{
Note that all the variables are fabricated using the actual MIDUS data
used in Park et al. (2023).
}
\references{
Park, S., Kang, S., Lee, C., & Ma, S. (2023). Sensitivity Analysis
for Causal Decomposition Analysis: Assessing Robustness Toward Omitted Variable Bias,
Journal of Causal Inference. Forthcoming.
}
\keyword{datasets}
