% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caugi.R
\name{caugi}
\alias{caugi}
\title{Create a \code{caugi} from edge expressions.}
\usage{
caugi(
  ...,
  from = NULL,
  edge = NULL,
  to = NULL,
  nodes = NULL,
  edges_df = NULL,
  simple = TRUE,
  build = TRUE,
  class = c("UNKNOWN", "DAG", "PDAG", "UG"),
  state = NULL
)
}
\arguments{
\item{...}{Edge expressions using the supported infix operators, or
nodes given by symbols or strings. Multiple edges can be
combined using \code{+}: \verb{A --> B + C}, indicating an edge from \code{A} to both \code{B}
and \code{C}. Nodes can also be grouped using \code{c(...)} or parentheses.}

\item{from}{Character vector of source node names.
Optional; mutually exclusive with \code{...}.}

\item{edge}{Character vector of edge types.
Optional; mutually exclusive with \code{...}.}

\item{to}{Character vector of target node names.
Optional; mutually exclusive with \code{...}.}

\item{nodes}{Character vector of node names to declare as isolated nodes.
An optional, but recommended, option is to provide all node names in the
graph, including those that appear in edges. If \code{nodes} is provided, the
order of nodes in the graph will follow the order in \code{nodes}.}

\item{edges_df}{Optional data.frame or data.table with columns
\code{from}, \code{edge}, and \code{to} to specify edges. Mutually exclusive with \code{...}
and \code{from}, \code{edge}, \code{to}. Can be used to create graphs using \code{edges(cg)}
from another \code{caugi} object, \code{cg}.}

\item{simple}{Logical; if \code{TRUE} (default), the graph is a simple graph, and
the function will throw an error if the input contains parallel edges or
self-loops.}

\item{build}{Logical; if \code{TRUE} (default), the graph will be built using the
Rust backend. If \code{FALSE}, the graph will not be built, and the Rust backend
cannot be used. The graph will build, when queries are made to the graph or
if calling \code{\link[=build]{build()}}. \strong{Note}: Even if \code{build = TRUE}, if no edges or
nodes are provided, the graph will not be built and the pointer will be
\code{NULL}.}

\item{class}{Character; one of \code{"UNKNOWN"}, \code{"DAG"}, \code{"PDAG"}, or \code{"UG"}.}

\item{state}{For internal use. Build a graph by supplying a pre-constructed
state environment.}
}
\value{
A \code{caugi} S7 object containing the nodes, edges, and a
pointer to the underlying Rust graph structure.
}
\description{
Create a \code{caugi} from a series of edge expressions using
infix operators. Nodes can be specified as symbols, strings, or numbers.

The following edge operators are supported by default:
\itemize{
\item \verb{\%-->\%} for directed edges (A --> B)
\item \verb{\%---\%} for undirected edges (A --- B)
\item \verb{\%<->\%} for bidirected edges (A <-> B)
\item \verb{\%o->\%} for partially directed edges (A o-> B)
\item \verb{\%--o\%} for partially undirected edges (A --o B)
\item \verb{\%o-o\%} for partial edges (A o-o B)
}

You can register additional edge types using \code{\link[=register_caugi_edge]{register_caugi_edge()}}.
}
\examples{
# create a simple DAG (using NSE)
cg <- caugi(
  A \%-->\% B + C,
  B \%-->\% D,
  class = "DAG"
)

# create a PDAG with undirected edges (using NSE)
cg2 <- caugi(
  A \%-->\% B + C,
  B \%---\% D,
  E, # no neighbors for this node
  class = "PDAG"
)

# create a DAG (using SE)
cg3 <- caugi(
  from = c("A", "A", "B"),
  edge = c("-->", "-->", "-->"),
  to = c("B", "C", "D"),
  nodes = c("A", "B", "C", "D", "E"),
  class = "DAG"
)

# create a non-simple graph
cg4 <- caugi(
  A \%-->\% B,
  B \%-->\% A,
  class = "UNKNOWN",
  simple = FALSE
)

cg4@simple # FALSE
cg4@built # TRUE
cg4@graph_class # "UNKNOWN"

# create graph, but don't built Rust object yet, which is needed for queries
cg5 <- caugi(
  A \%-->\% B + C,
  B \%-->\% D,
  class = "DAG",
  build = FALSE
)

cg@built # FALSE

}
\concept{caugi}
