% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFunctionEnvelopePara.R
\name{getFunctionEnvelopePara}
\alias{getFunctionEnvelopePara}
\title{Function to return function envelope for parabola}
\usage{
getFunctionEnvelopePara(data, R = 1000, x)
}
\arguments{
\item{data}{data frame with columns \code{x} and \code{y}}
}
\value{
data frame with x, lwr and upr
}
\description{
Use boostrap to get bands of possible fits to data using quadratic
}
\note{
February 12 2013
}
\examples{
x <- runif(100,0,10)
y <- x^2 + 2*x + 3 + rnorm(100,sd=20)
df <- data.frame(x=x,y=y)
plot(y~x,data=df,pch=16,cex=0.5)
bounds <- getFunctionEnvelopePara(data=df,x=seq(0,10,l=100))
lines(bounds$x,bounds$lwr)
lines(bounds$x,bounds$upr)
}
\author{
Jono Tuke, Matthew Roughan
}
\keyword{internal}
