% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cata.R
\encoding{UTF-8}
\name{bcluster.n}
\alias{bcluster.n}
\title{b-cluster analysis by non-hierarchical iterative ascent clustering
strategy}
\usage{
bcluster.n(X, G, M = NULL, measure = "b", max.iter = 500, runs = 1,
X.input = "data", tol = exp(-32), seed = 2021)
}
\arguments{
\item{X}{CATA data organized in a three-way array (assessors, products, 
attributes)}

\item{G}{number of clusters (required for non-hierarchical algorithm)}

\item{M}{initial cluster memberships (default: \code{NULL}), but can be a vector
(one run) or a matrix (consumers in rows; runs in columns)}

\item{measure}{\code{b} (default) for the \code{b}-measure is implemented}

\item{max.iter}{maximum number of iteration allowed (default \code{500})}

\item{runs}{number of runs (defaults to \code{1})}

\item{X.input}{either \code{"data"} (default) or \code{"bc"} if \code{X} is
obtained from the function \code{\link[cata]{barray}}}

\item{tol}{algorithm stops if variance over 5 iterations is less than 
\code{tol} (default: \code{exp(-32)})}

\item{seed}{for reproducibility (default is \code{2021})}
}
\value{
An object of class \code{bclust.n} (or a list of such objects 
if \code{runs>1}), where each such object has the following components: 
\itemize{
\item{\code{cluster} : vector of the final cluster memberships}
\item{\code{totalB} : value of the total sensory differentiation in data set}
\item{\code{retainedB} : value of sensory differentiation retained in b-cluster
analysis solution}
\item{\code{progression} : vector of sensory differentiation retained in each 
iteration}
\item{\code{iter} : number of iterations completed}
\item{\code{finished} : boolean indicates whether the algorithm converged 
before \code{max.iter}}}
}
\description{
Non-hierarchical b-cluster analysis transfers assessors iteratively to
reach a local maximum in sensory differentiation retained.
}
\examples{
data(bread)

# b-cluster analysis on the first 8 consumers and the first 5 attributes
(b <- bcluster.n(bread$cata[1:8, , 1:5], G=2))
}
\references{
Castura, J.C., Meyners, M., Varela, P., & Næs, T. (2022). 
Clustering consumers based on product discrimination in check-all-that-apply 
(CATA) data. \emph{Food Quality and Preference}, 104564. 
\doi{10.1016/j.foodqual.2022.104564}.
}
