% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{expectedObsInf}
\alias{expectedObsInf}
\title{Expected Observed Information}
\usage{
expectedObsInf(catObj, item)
}
\arguments{
\item{catObj}{An object of class \code{Cat}}

\item{item}{An integer indicating the index of the question item}
}
\value{
The function \code{expectedObsInf} returns a numeric value of the expected information.
}
\description{
Calculates the expected information, which is the observed information attained from a specific response set times the probability of that profile occurring.
}
\note{
This function is to allow users to access the internal functions of the package. During item selection, all calculations are done in compiled \code{C++} code.
}
\examples{
## Loading ltm Cat object
data(ltm_cat)

## Store example answers
setAnswers(ltm_cat) <- c(1,0,1,0,1, rep(NA, 35))

## Expected observed information for different items
expectedObsInf(ltm_cat, item = 10)
expectedObsInf(ltm_cat, item = 20)


}
\seealso{
\code{\link{estimateSE}},\code{\link{obsInf}}, \code{\link{probability}}, \code{\link{selectItem}}
}
\author{
Haley Acevedo, Ryden Butler, Josh W. Cutler, Matt Malis, Jacob M. Montgomery,
 Tom Wilkinson, Erin Rossiter, Min Hee Seo, Alex Weil
}
