% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_ard_order.R
\name{tidy_ard_order}
\alias{tidy_ard_order}
\alias{tidy_ard_column_order}
\alias{tidy_ard_row_order}
\title{Standard Order of ARD}
\usage{
tidy_ard_column_order(x)

tidy_ard_row_order(x)
}
\arguments{
\item{x}{(\code{data.frame})\cr
an ARD data frame of class 'card'}
}
\value{
an ARD data frame of class 'card'
}
\description{
ARD functions for relocating columns and rows to the standard order.
\itemize{
\item \code{tidy_ard_column_order()} relocates columns of the ARD to the standard order.
\item \code{tidy_ard_row_order()} orders rows of ARD according to variables, groups, and
strata, while retaining the order of the input ARD.
}
}
\examples{
# order columns
ard <-
  dplyr::bind_rows(
    ard_continuous(mtcars, variables = "mpg"),
    ard_continuous(mtcars, variables = "mpg", by = "cyl")
  )

tidy_ard_column_order(ard) |>
  tidy_ard_row_order()
}
