% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_fmt_fn.R
\name{alias_as_fmt_fn}
\alias{alias_as_fmt_fn}
\title{Convert Alias to Function}
\usage{
alias_as_fmt_fn(x, call = parent.frame())
}
\arguments{
\item{x}{(\code{integer}, \code{string}, or \code{function})\cr
a non-negative integer, string alias, or function}

\item{call}{(\code{environment})\cr
frame for error messaging. Default is \code{\link[=parent.frame]{parent.frame()}}.}
}
\value{
a function
}
\description{
Accepted aliases are non-negative integers and strings.

The integers are converted to functions that round the statistics
to the number of decimal places to match the integer.

The formatting strings come in the form \code{"xx"}, \code{"xx.x"}, \code{"xx.x\%"}, etc.
The number of \code{x}s that appear after the decimal place indicate the number of
decimal places the statistics will be rounded to.
The number of \code{x}s that appear before the decimal place indicate the leading
spaces that are added to the result.
If the string ends in \code{"\%"}, results are scaled by 100 before rounding.
}
\examples{
alias_as_fmt_fn(1)
alias_as_fmt_fn("xx.x")
}
