% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rail_emissions.R
\name{rail_emissions}
\alias{rail_emissions}
\title{Calculate CO2e emissions from a train journey}
\usage{
rail_emissions(
  from,
  to,
  via = NULL,
  num_people = 1,
  times_journey = 1,
  include_WTT = TRUE,
  round_trip = FALSE
)
}
\arguments{
\item{from}{Station departing from.}

\item{to}{Station arriving to}

\item{via}{Optional. Takes a vector containing the stations the train travels via.}

\item{num_people}{Number of people taking the journey. Takes a single numerical value.}

\item{times_journey}{Number of times the journey is taken.}

\item{include_WTT}{logical. Recommended \code{TRUE}. Whether to include emissions associated with extracting, refining, and transporting fuels.}

\item{round_trip}{Whether the journey is one-way or return.}
}
\value{
Returns CO2e emissions in tonnes for the train journey.
}
\description{
A function that calculates CO2e emissions between train stations in the UK.
}
\details{
The distances are calculated using the Haversine formula. This is calculated as the crow flies. As a result, inputting the "via" journeys will make for a more reliable function.
}
\examples{
# Emissions for a train journey between Southampton Central and
# Manchester Piccadilly Station
rail_emissions("Southampton Central", "Manchester Piccadilly")

# Emissions for a train journey between Bristol Temple Meads and
# London Paddington via Bath, Swindon, and Reading
# Use the \code{rail_finder} function to find the name of London Paddington
rail_finder(region = "London")
# Then calculate emissions
rail_emissions("Bristol Temple Meads", "Paddington", via = c("Bath Spa",
"Swindon", "Reading"))
}
