% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/building_emissions.R
\name{building_emissions}
\alias{building_emissions}
\title{Building emissions}
\usage{
building_emissions(
  water_supply = 0,
  water_trt = TRUE,
  water_unit = c("cubic metres", "million litres"),
  electricity_kWh = 0,
  electricity_TD = TRUE,
  electricity_WTT = TRUE,
  heat_kWh = 0,
  heat_TD = TRUE,
  heat_WTT = TRUE
)
}
\arguments{
\item{water_supply}{Amount of water used in the building.}

\item{water_trt}{logical. Default \code{TRUE}. Whether to include emissions associated with water treatment for used water.}

\item{water_unit}{Unit for \code{water_supply} variable. Options are \code{"cubic metres"} or \code{"million litres"}.}

\item{electricity_kWh}{Electricity used in kWh.}

\item{electricity_TD}{logical. Default \code{TRUE}. Whether to include emissions associated with grid losses.}

\item{electricity_WTT}{logical. Default \code{TRUE}. Whether to include emissions associated with extracting, refining, and transporting fuels.}

\item{heat_kWh}{heat and steam used in kWh.}

\item{heat_TD}{logical. Default \code{TRUE}. Whether to include emissions associated with grid losses.}

\item{heat_WTT}{logical. Default \code{TRUE}. Whether to include emissions associated with extracting, refining, and transporting fuels.}
}
\value{
Returns CO2e emissions in tonnes.
}
\description{
Further options are given in the \code{raw_fuels} function.
}
\examples{
# specify emissions in an office
building_emissions(electricity_kWh = 200,
                 heat_kWh = 100, water_supply = 100, water_trt = FALSE)

}
\references{
Descriptions from 2022 UK Government Report: https://www.gov.uk/government/publications/greenhouse-gas-reporting-conversion-factors-2022
}
