# Bonferroni test for an outlier (J. Fox)

# last modified 9 Nov 02 by J. Fox

outlier.test<-function(model, ...){
    UseMethod("outlier.test")
    }

outlier.test.lm<-function(model, labels=names(rstud), ...){
    #last modified 13 Nov 2001 by J. Fox
    rstud<-abs(rstudent(model))
    labels<-if(is.null(labels)) seq(along=rstud) else labels
    if (length(rstud) != length(labels)) 
        stop("Number of labels does not correspond to number of residuals.")
    rstud.max<-max(rstud, na.rm=TRUE)
    which.max<-which(rstud==rstud.max)
    df<-df.residual(model)-1
    n<-sum(!is.na(rstud))
    p<-2*(1-pt(rstud.max,df))
    bp <- if (n*p <= 1) n*p else NA
    result<-c(rstud.max, df, p, bp)
    names(result)<-c("max|rstudent|", "df", "unadjusted p", "Bonferroni p")
    result<-list(test=result, obs=labels[which.max])
    class(result)<-"outlier.test"
    result
    }
    
outlier.test.glm<-function(model, labels=names(rstud), ...){
    #last modified 13 Nov 2001 by J. Fox
    rstud<-abs(rstudent(model))
    labels<-if(is.null(labels)) seq(along=rstud) else labels
    if (length(rstud) != length(labels)) 
        stop("Number of labels does not correspond to number of residuals.")
    rstud.max<-max(rstud, na.rm=TRUE)
    which.max<-which(rstud==rstud.max)
    n<-sum(!is.na(rstud))
    p<-2*(1-pnorm(rstud.max))
    bp <- if (n*p <= 1) n*p else NA
    result<-c(rstud.max, p, bp)
    names(result)<-c("max|rstudent|", "unadjusted p", "Bonferroni p")
    result<-list(test=result, obs=labels[which.max])
    class(result)<-"outlier.test"
    result
    }

    
print.outlier.test<-function(x, ...){
    # last modified 27 Jan 2001 by J. Fox
    test<-matrix(x$test, nrow=1)
    colnames(test)<-names(x$test)
    rownames(test)<-""
    print.matrix(test)
    if(length(x$obs)>1) cat("\nObservations:",x$obs,"\n")
      else cat("\nObservation:",x$obs,"\n")
    }
