% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/physical_competence.R
\name{get_camsa_skill_time_score}
\alias{get_camsa_skill_time_score}
\title{Compute the CAMSA skill + time score.}
\usage{
get_camsa_skill_time_score(camsa_skill_score = NA, camsa_time_score = NA)
}
\arguments{
\item{camsa_skill_score}{A numeric (integer) vector representing the CAMSA skill score (valid values are between 0 and 14).}

\item{camsa_time_score}{A numeric vector representing the CAMSA time score (valid values are between 1 and 14).}
}
\value{
Returns a numeric (integer) vector with values between 1 and 28 (if valid) or NA (if not valid).
}
\description{
This function computes the CAMSA (Canadian Agility and Movement Skill Assessment) skill + time score (e.g., \code{camsa_skill_time_score1}) for a given trial.
This score is used to compute the CAMSA score (\code{camsa_score}).
}
\details{
Other \code{capl} functions called by this function include: \code{\link[=validate_scale]{validate_scale()}}.
}
\examples{
get_camsa_skill_time_score(
  camsa_skill_score = c(0, 5, 10, 14, 15),
  camsa_time_score = c(1, 10, 12, 15, 30)
)

# [1]  1 15 22 NA NA

}
