% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pairs_for_pairscan.R
\name{get_pairs_for_pairscan}
\alias{get_pairs_for_pairscan}
\title{Select marker pairs for pairscan}
\usage{
get_pairs_for_pairscan(
  gene,
  covar_names = NULL,
  max_pair_cor = NULL,
  min_per_genotype = NULL,
  run_parallel = FALSE,
  n_cores = 4,
  verbose = FALSE
)
}
\arguments{
\item{gene}{A two dimensional genotype matrix with rows containing 
individuals and columns containing markers. Each entry is a value between
0 and 1 indicating the genotype of each individual at each marker.}

\item{covar_names}{A character vector indicating which covariates should
be tested.}

\item{max_pair_cor}{A numeric value between 0 and 1 indicating the maximum
Pearson correlation that two markers are allowed. If the correlation
between a pair of markers exceeds this threshold, the pair is not tested.
If this value is set to NULL, min_per_genotype must have a numeric value.}

\item{min_per_genotype}{The minimum number of individuals allowable per 
genotype. If for a given marker pair, one of the genotypes is 
underrepresented, the marker pair is not tested. If this value is NULL,
max_pair_cor must have a numeric value.}

\item{run_parallel}{A logical value indicating whether multiple 
processors should be used.}

\item{n_cores}{The number of cores to be used if run_parallel is TRUE}

\item{verbose}{A logical value. If TRUE, the script prints a message to the
screen to indicate that it is running. If FALSE, no message is printed.}
}
\value{
This function returns a two-column matrix of marker pairs. This
  matrix is then used as an argument in \code{\link{one_pairscan_parallel}}, 
  \code{\link{pairscan_null_kin}}, \code{\link{pairscan_null}} and 
  \code{\link{pairscan}} to specify which marker pairs should be tested.
}
\description{
This function selects which marker pairs can be tested in the pair scan.
Even if all markers are linearly independent, some marker pairs may have
insufficient recombination between them to populate all genotype
combinations. Marker pairs for which genotype combinations have insufficient
numbers of individuals are not tested. This function determines which marker
pairs have sufficient representation in all genotype combinations.
}
\details{
One and only one of min_per_genotype or max_pair_cor should be specified.
We recommend that if you have continuous genotype probabilities, you use max_pair_cor.
If both values are specified, this function will preferentially use max_pair_cor.
}
\examples{
\dontrun{
gene <- data_obj$geno_for_pairscan
data_obj <- get_pairs_for_pairscan(gene)
}

}
