% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/census_vectors.R
\name{parent_census_vectors}
\alias{parent_census_vectors}
\title{List all parent variables from vector hierarchies given either a list of Census
variables returned by
\code{list_census_vectors} or \code{search_census_vectors}, or a direct string reference to the vector code.}
\usage{
parent_census_vectors(vector_list)
}
\arguments{
\item{vector_list}{The list of vectors to be used, either a character vector or a filtered tibble
as returned from \code{list_census_vectors}.}
}
\description{
List all parent variables from vector hierarchies given either a list of Census
variables returned by
\code{list_census_vectors} or \code{search_census_vectors}, or a direct string reference to the vector code.
}
\examples{
# Query parent vectors directly using vector identifier
parent_census_vectors("v_CA16_2519")
\dontrun{
# Example using multiple vectors coerced into a list
parent_census_vectors(c("v_CA16_2519","v_CA16_2520","v_CA16_2521"))

# or, equivalently
selected_vectors <- c("v_CA16_2519","v_CA16_2520","v_CA16_2521")
parent_census_vectors(selected_vectors)

# Example using dplyr and piped arguments
library(dplyr, warn.conflicts = FALSE)

list_census_vectors("CA16") \%>\%
  filter(vector == "v_CA16_2519") \%>\%
  parent_census_vectors()
}
}
