% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_coef,commOccu-method}
\alias{plot_coef,commOccu-method}
\alias{plot_coef}
\title{Plot effect sizes of covariates in community occupancy model}
\usage{
\S4method{plot_coef}{commOccu}(
  object,
  mcmc.list,
  submodel = "state",
  ordered = TRUE,
  combine = FALSE,
  outdir,
  level = c(outer = 0.95, inner = 0.75),
  colorby = "significance",
  ...
)
}
\arguments{
\item{object}{\code{commOccu} object}

\item{mcmc.list}{mcmc.list. Output of \code{\link{fit}} called on a \code{commOccu} object}

\item{submodel}{Submodel to get plots for. Can be "det" or "state"}

\item{ordered}{logical. Order species in plot by median effect (TRUE) or by species name (FALSE)}

\item{combine}{logical. Combine multiple plots into one (via facets)?}

\item{outdir}{Directory to save plots to (optional)}

\item{level}{Probability mass to include in the uncertainty interval (two values, second value - inner interval - will be plotted thicker)}

\item{colorby}{Whether to color estimates by "significance" (of the effect estimates), or "Bayesian p-value" (of the species)}

\item{...}{additional arguments for \code{\link[ggplot2]{ggsave}}}
}
\value{
list of ggplot objects
}
\description{
Plot effect sizes for all species in a community (multi-species) occupancy model. Currently only supports continuous covariates, not categorical covariates.
}
