% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sliding.pixel.comparison.R
\name{sliding.pixel.comparison}
\alias{sliding.pixel.comparison}
\title{sliding.pixel.comparison}
\usage{
sliding.pixel.comparison(s1, s2, step_size = 1)
}
\arguments{
\item{s1}{numeric matrix, the first spectrogram.}

\item{s2}{numeric matrix, the second spectrogram.}

\item{step_size}{numeric, how many pixels should be moved for each step.
Default is `1`.}
}
\value{
Returns the distance at the point of maximal signal overlap.
}
\description{
Can be used to run spectrographic cross correlation. Both
spectrograms are zero-padded and slid over each other. For each step the
difference is computed. The function returns the absolute difference at the
point at the minimum (maximal signal overlap).
}
\examples{
require(callsync)
require(seewave)
require(tuneR)
path_git = 'https://raw.githubusercontent.com'
path_repo = '/simeonqs/callsync/master/tests/testthat/files'
file_1 = '/wave_1.wav'
file_2 = '/wave_2.wav'
url_1 = paste0(path_git, path_repo, file_1)
url_2 = paste0(path_git, path_repo, file_2)
local_file_1 = paste(tempdir(), file_1, sep = '/')
local_file_2 = paste(tempdir(), file_2, sep = '/')
if(!file.exists(local_file_1))
  download.file(url_1, destfile = local_file_1, mode = 'wb',)
if(!file.exists(local_file_2))
  download.file(url_2, destfile = local_file_2, mode = 'wb')
wave_1 = readWave(local_file_1)
wave_2 = readWave(local_file_2)
so_1 = create.spec.object(wave = wave_1, plot_it = FALSE)
so_2 = create.spec.object(wave = wave_2, plot_it = FALSE)
out = sliding.pixel.comparison(so_1, so_2)

}
