% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_datacube.R
\name{subset_datacube}
\alias{subset_datacube}
\title{subset_datacube}
\usage{
subset_datacube(r, from, to)
}
\arguments{
\item{r}{is the Raster layer to compare to the climatology.}

\item{from}{string, starting date (e.g. "2018-12-30").}

\item{to}{string, ending date (e.g. "2018-12-31").}
}
\value{
The function returns a subset of \code{r}, with layer's date in the
range starting with \code{from} and ending with \code{to}.
}
\description{
This function subsets a datacube (RasterStack or RasterBrick)
based on dates.
}
\details{
If the \code{from} and \code{to} strings are in the format
"YYYY-MM-DD", they are automatically converted into a date.
}
\examples{
\dontrun{
  r <- raster(nrows = 2, ncols = 2,
              xmn = 0, xmx = 360, ymn = -90, ymx = 90, vals = 30)
  # Generate dummy RasterBrick
  b <- raster::brick(lapply(1:(365 * 3),
                     function(i) raster::setValues(r,
                     unif(n = raster::ncell(r), min = 0, max = 100))))
  names(b) <- seq.Date(from = as.Date("1993-01-01"),
                       to = as.Date("1995-12-31"),
                       by = "day")
  subset_datacube(r = b, from = "1993-01-01", to = "1993-01-01")
}

}
