% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components-generated.R
\name{calcite_list}
\alias{calcite_list}
\title{Create a List component}
\usage{
calcite_list(...)
}
\arguments{
\item{...}{named attributes passed to \code{htmltools::tag()}}
}
\value{
an object of class \code{calcite_component} which is a subclass of \code{shiny.tag}
}
\description{
Create a List component
}
\details{
A general purpose list that enables users to construct list items that conform to Calcite styling.
\subsection{Properties}{

The following properties are provided by this component:\tabular{lllll}{
   Name \tab Attribute \tab Description \tab Values \tab Reflects to Attribute \cr
   canPull \tab NA \tab When provided, the method will be called to determine whether the element can  move from the list. \tab (detail: ListDragDetail) => boolean \tab FALSE \cr
   canPut \tab NA \tab When provided, the method will be called to determine whether the element can be added from another list. \tab (detail: ListDragDetail) => boolean \tab FALSE \cr
   disabled \tab disabled \tab When \code{true}, interaction is prevented and the component is displayed with lower opacity. \tab boolean \tab TRUE \cr
   displayMode \tab display-mode \tab Specifies the nesting behavior of \code{calcite-list-item}s, where  \code{"flat"} displays \code{calcite-list-item}s in a uniform list, and  \code{"nested"} displays \code{calcite-list-item}s under their parent element.   The parent component's behavior should follow throughout its child elements. \tab "flat" | "nested" \tab TRUE \cr
   dragEnabled \tab drag-enabled \tab When \code{true}, \code{calcite-list-item}s are sortable via a draggable button. \tab boolean \tab TRUE \cr
   filteredData \tab NA \tab The currently filtered \code{calcite-list-item} data. \tab Check API reference \tab FALSE \cr
   filteredItems \tab NA \tab The currently filtered \code{calcite-list-item}s. \tab Check API reference \tab FALSE \cr
   filterEnabled \tab filter-enabled \tab When \code{true}, an input appears at the top of the component that can be used by end users to filter \code{calcite-list-item}s. \tab boolean \tab TRUE \cr
   filterLabel \tab filter-label \tab Specifies an accessible name for the filter input field. \tab string \tab TRUE \cr
   filterPlaceholder \tab filter-placeholder \tab Placeholder text for the component's filter input field. \tab string \tab TRUE \cr
   filterPredicate \tab NA \tab Specifies a function to handle filtering. \tab (item: HTMLCalciteListItemElement) => boolean \tab FALSE \cr
   filterProps \tab NA \tab Specifies the properties to match against when filtering. If not set, all properties will be matched (label, description, metadata, value, group heading). \tab Check API reference \tab FALSE \cr
   filterText \tab filter-text \tab Text for the component's filter input field. \tab string \tab TRUE \cr
   group \tab group \tab The list's group identifier.  To drag elements from one list into another, both lists must have the same group value. \tab string \tab TRUE \cr
   interactionMode \tab interaction-mode \tab Specifies the interaction mode of the component.  \code{"interactive"} allows interaction styling and pointer changes on hover  \code{"static"} does not allow interaction styling and pointer changes on hover  The \code{"static"} value should only be used when \code{selectionMode} is \code{"none"}. \tab "interactive" | "static" \tab TRUE \cr
   label \tab label \tab Specifies an accessible name for the component.  When \code{dragEnabled} is \code{true} and multiple list sorting is enabled with \code{group}, specifies the component's name for dragging between lists. \tab string \tab FALSE \cr
   loading \tab loading \tab When \code{true}, a busy indicator is displayed. \tab boolean \tab TRUE \cr
   messageOverrides \tab NA \tab Use this property to override individual strings used by the component. \tab Check API reference \tab FALSE \cr
   numberingSystem \tab numbering-system \tab Specifies the Unicode numeral system used by the component for localization. \tab "arab" | "arabext" | "latn" \tab FALSE \cr
   scale \tab scale \tab Specifies the size of the component. \tab "l" | "m" | "s" \tab TRUE \cr
   selectedItems \tab NA \tab The currently selected items. \tab Check API reference \tab FALSE \cr
   selectionAppearance \tab selection-appearance \tab Specifies the selection appearance - \code{"icon"} (displays a checkmark or dot) or \code{"border"} (displays a border). \tab "border" | "icon" \tab TRUE \cr
   selectionMode \tab selection-mode \tab Specifies the selection mode of the component, where:  \code{"multiple"} allows any number of selections,  \code{"single"} allows only one selection,  \code{"single-persist"} allows one selection and prevents de-selection, and  \code{"none"} does not allow any selections. \tab "multiple" | "none" | "single" | "single-persist" \tab TRUE \cr
}

}

\subsection{Events}{

The following events are observed by shiny:\tabular{ll}{
   Event \tab Description \cr
   calciteListChange \tab Fires when the component's selected items have changed. \cr
   calciteListDragEnd \tab Fires when the component's dragging has ended. \cr
   calciteListDragStart \tab Fires when the component's dragging has started. \cr
   calciteListFilter \tab Fires when the component's filter has changed. \cr
   calciteListOrderChange \tab Fires when the component's item order changes. \cr
}

}

\subsection{Slots}{

The following slots are provided by this component:\tabular{ll}{
   Slot \tab Description \cr
   Default (unnamed) \tab A slot for adding \code{calcite-list-item} and \code{calcite-list-item-group} elements. \cr
   filter-actions-start \tab A slot for adding actionable \code{calcite-action} elements before the filter component. \cr
   filter-actions-end \tab A slot for adding actionable \code{calcite-action} elements after the filter component. \cr
   filter-no-results \tab When \code{filterEnabled} is \code{true}, a slot for adding content to display when no results are found. \cr
}

}
}
\examples{
calcite_list()
}
\references{
\href{https://developers.arcgis.com/calcite-design-system/components/list/}{Official Documentation}
}
